﻿//////////////////////////////////////////////
// CompositeEncoder.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkGraphics
#include "../../Dll/DllDefines.h"

#include "../Data/DecodedData.h"

#include "CompositeDecodeOptions.h"

// nkMemory
#include <NilkinsMemory/Containers/BufferView.h>

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT CompositeEncoder final
	{
		public :

			// Decoding
			static bool canDecode (const nkMemory::BufferView<>& sources) ;
			static DecodedData decode (const nkMemory::BufferView<>& sources, const CompositeDecodeOptions& options = CompositeDecodeOptions()) ;
	} ;
}